#include "main.h"


short initfmod(void)
{

    int audio_samplerate;
    int returncode;
    int sndinit_tries;

    /*FILE *fp;*/

    tuneptr = NULL;
    sndinit_tries = 1;
    returncode = 0;
    audio_samplerate = 44100;

    /* Initialize fmod */
    while (!FSOUND_Init(audio_samplerate, 24, 0)) {
        audio_samplerate = (44100 / ++sndinit_tries);
        if (audio_samplerate <= 5512) {
            printf("\nERROR: ");
            switch (FSOUND_GetError()) {
            case FMOD_ERR_INIT:
                break;
            case FMOD_ERR_ALLOCATED:
                break;
            case FMOD_ERR_OUTPUT_FORMAT:
                break;
            default:
                break;
            }
            return -1;
        }
    }


    stream = FSOUND_Stream_Open( "sfx/song.ogg", FSOUND_2D,0,0);

    FSOUND_DSP_SetActive(FSOUND_DSP_GetFFTUnit(), 1);

    return 0;

}

void kill_sound(void){
  FSOUND_Stream_Stop(stream);
  FSOUND_Stream_Close(stream);
      
  FSOUND_Close();
}

